/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWRoleAttributeRowItem;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

class VWRoleAttributesTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_VALUE = 2;
    protected static final String ARRAY = "[ ]";
    private VWSessionInfo m_sessionInfo = null;
    private VWRoleDefinition m_roleDef = null;
    private boolean m_bIsModified = false;
    private JComboBox m_fieldTypeComboBox = null;
    private ArrayList<VWRoleAttributeRowItem> m_rowData = null;
    private VWRoleAttributeRowItem m_tempAttributeRowItem = null;

    public VWRoleAttributesTableModel(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_name;
            }
            case 1: {
                return VWResource.s_type;
            }
            case 2: {
                return VWResource.s_value;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWRoleAttributeRowItem attributeRowItem = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (attributeRowItem == null) break;
                    return attributeRowItem.getName();
                }
                case 1: {
                    if (attributeRowItem != null) {
                        return attributeRowItem.getTypeString();
                    }
                    return this.m_tempAttributeRowItem.getTypeString();
                }
                case 2: {
                    if (attributeRowItem != null) {
                        return new VWFieldDataForTable(attributeRowItem.getType(), attributeRowItem.isArray(), attributeRowItem.getValue(), attributeRowItem.getName());
                    }
                    return new VWFieldDataForTable(this.m_tempAttributeRowItem.getType(), this.m_tempAttributeRowItem.isArray(), this.m_tempAttributeRowItem.getValue(), this.m_tempAttributeRowItem.getName());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object value, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(value, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateValue(value, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateType(value, nRowIndex);
            }
        }
    }

    protected void releaseReferences() {
        if (this.m_fieldTypeComboBox != null) {
            this.m_fieldTypeComboBox.removeAll();
            this.m_fieldTypeComboBox = null;
        }
        if (this.m_rowData != null) {
            this.m_rowData = null;
        }
        this.m_tempAttributeRowItem = null;
        this.m_sessionInfo = null;
        this.m_roleDef = null;
    }

    protected void deleteItem(int nRowIndex) {
        block3: {
            try {
                VWRoleAttributeRowItem attributeRowItem = this.getItemAt(nRowIndex);
                if (attributeRowItem != null) {
                    attributeRowItem.remove(this.m_roleDef);
                    this.m_rowData.remove(nRowIndex);
                    this.m_bIsModified = true;
                    this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_sessionInfo == null) break block3;
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    protected void setSelectedRole(VWRoleDefinition roleDef) {
        try {
            Object[] attributeNames;
            VWAttributeInfo attributeInfo;
            this.m_tempAttributeRowItem = new VWRoleAttributeRowItem();
            this.m_rowData = new ArrayList();
            this.m_bIsModified = false;
            this.m_roleDef = roleDef;
            if (this.m_roleDef != null && (attributeInfo = this.m_roleDef.getAttributeInfo()) != null && (attributeNames = attributeInfo.getAttributeNames()) != null && attributeNames.length > 0) {
                VWQubbleSort.sort(attributeNames);
                for (int i = 0; i < attributeNames.length; ++i) {
                    Object name = attributeNames[i];
                    if (((String)name).length() > 2 && ((String)name).substring(1, 2).compareTo("F_") == 0 || ((String)name).compareTo("UI_StepType") == 0) continue;
                    int nType = attributeInfo.getFieldType((String)name);
                    boolean bIsArray = attributeInfo.isFieldArray((String)name);
                    Object value = attributeInfo.getFieldValue((String)name);
                    this.m_rowData.add(new VWRoleAttributeRowItem((String)name, nType, bIsArray, value, 0));
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean isModified() {
        if (this.m_bIsModified) {
            return true;
        }
        try {
            if (this.m_rowData != null) {
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    VWRoleAttributeRowItem obj = this.m_rowData.get(i);
                    if (obj == null || !(obj instanceof VWRoleAttributeRowItem) || !obj.isModified()) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected JComboBox getFieldTypeComboBox() {
        try {
            if (this.m_fieldTypeComboBox == null) {
                this.m_fieldTypeComboBox = new JComboBox();
                this.m_fieldTypeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + ARRAY);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                this.m_fieldTypeComboBox.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_fieldTypeComboBox;
    }

    private VWRoleAttributeRowItem getItemAt(int nRowIndex) {
        try {
            VWRoleAttributeRowItem obj;
            if (this.m_rowData != null && nRowIndex < this.m_rowData.size() && (obj = this.m_rowData.get(nRowIndex)) != null && obj instanceof VWRoleAttributeRowItem) {
                return obj;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void onUpdateName(Object value, int nRowIndex) {
        block9: {
            try {
                String newName;
                if (value != null && (newName = (String)value).length() > 0) {
                    VWRoleAttributeRowItem attributeRowItem = this.getItemAt(nRowIndex);
                    if (attributeRowItem != null) {
                        String oldName = attributeRowItem.getName();
                        if (VWStringUtils.compare(newName, oldName) == 0) {
                            return;
                        }
                        if (this.isExistingName(newName)) {
                            throw new VWException("vw.toolkit.design.property.tables.AttributeNameInUse", "The attribute name is already in use.");
                        }
                        attributeRowItem.setName(newName, this.m_roleDef);
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        if (this.isExistingName(newName)) {
                            throw new VWException("vw.toolkit.design.property.tables.AttributeNameInUse", "The attribute name is already in use.");
                        }
                        this.m_tempAttributeRowItem.setName(newName, this.m_roleDef);
                        if (VWStringUtils.compare(newName, "UI_IconName") == 0 || VWStringUtils.compare(newName, "UI_StepPropertiesPanelClass") == 0) {
                            this.m_tempAttributeRowItem.setType(2, false, null);
                        }
                        this.m_rowData.add(this.m_tempAttributeRowItem);
                        this.m_tempAttributeRowItem = new VWRoleAttributeRowItem();
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                    }
                    this.m_bIsModified = true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_sessionInfo == null) break block9;
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private boolean isExistingName(String name) {
        try {
            if (this.m_rowData != null) {
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    VWRoleAttributeRowItem obj = this.m_rowData.get(i);
                    if (obj == null || !(obj instanceof VWRoleAttributeRowItem) || VWStringUtils.compare(name, obj.getName()) != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private void onUpdateType(Object value, int nRowIndex) {
        block7: {
            try {
                if (value != null) {
                    String newType = (String)value;
                    VWRoleAttributeRowItem attribute = this.getItemAt(nRowIndex);
                    if (attribute != null) {
                        String oldType = attribute.getTypeString();
                        if (VWStringUtils.compare(oldType, newType) != 0) {
                            this.updateAttributeType(attribute, newType, this.m_roleDef);
                            this.m_bIsModified = true;
                        }
                    } else {
                        String oldType = this.m_tempAttributeRowItem.getTypeString();
                        if (VWStringUtils.compare(oldType, newType) != 0) {
                            this.updateAttributeType(this.m_tempAttributeRowItem, newType, null);
                        }
                    }
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_sessionInfo == null) break block7;
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private void updateAttributeType(VWRoleAttributeRowItem attribute, String newType, VWRoleDefinition roleDef) throws Exception {
        if (newType.compareTo(VWFieldType.getLocalizedString(4)) == 0) {
            attribute.setType(4, false, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(4) + ARRAY) == 0) {
            attribute.setType(4, true, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(8)) == 0) {
            attribute.setType(8, false, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(8) + ARRAY) == 0) {
            attribute.setType(8, true, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(1)) == 0) {
            attribute.setType(1, false, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(1) + ARRAY) == 0) {
            attribute.setType(1, true, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(2)) == 0) {
            attribute.setType(2, false, roleDef);
        } else if (newType.compareTo(VWFieldType.getLocalizedString(2) + ARRAY) == 0) {
            attribute.setType(2, true, roleDef);
        }
    }

    private void onUpdateValue(Object value, int nRowIndex) {
        block5: {
            try {
                if (value != null) {
                    VWRoleAttributeRowItem attributeRowItem = this.getItemAt(nRowIndex);
                    if (attributeRowItem != null) {
                        attributeRowItem.setValue(value, this.m_roleDef);
                        this.m_bIsModified = true;
                        this.fireTableCellUpdated(nRowIndex, 2);
                    } else {
                        this.m_tempAttributeRowItem.setValue(value, null);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_sessionInfo == null) break block5;
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }
}

